/*:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
::
::  Module      :   Encoder EMulator Framework API Header File
::  Copyright   :   (C)2005-2009 Woodward
::  Platform(s) :   MPC5xx
::  Limitations :   MPC5xx OS
::
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::*/
/*! \file Resource_EncoderEmulator.h
    \brief The Framework can support encoder emulators. An output is setup to track an input whilst supporting
           an optional phase delay that is specified in crank angle degrees
*/
#ifndef __RESOURCE_ENCODEREMULATOR_H
#define __RESOURCE_ENCODEREMULATOR_H

/*----- INCLUDES ------------------------------------------------------------------------------------------*/
#include <typedefn.h>
#include <resource.h>
#include <NativeError.h>

/*----- DEFINES -------------------------------------------------------------------------------------------*/

/*----- TYPEDEFS ------------------------------------------------------------------------------------------*/

/*----- EXTERNALS -----------------------------------------------------------------------------------------*/

/*----- PROTOTYPES ----------------------------------------------------------------------------------------*/
NativeError_S EncEmulator_Create(E_ModuleResource eResource,
                                 E_ModuleResource eInputResource,
                                 uint2 uDegCA_x256,
                                 uint1 bInvert);
NativeError_S EncEmulator_SamplePeriod_Refresh(E_ModuleResource eResource);
NativeError_S EncEmulator_Phase_Set(E_ModuleResource eResource, uint2 uPhase_x16DegCA, uint2 uVelocity_x65536DegPerDeg);
uint2 EncEmulator_CurrentPhase_Get(E_ModuleResource eResource);
uint1 EncEmulator_IsLocked(E_ModuleResource eResource);

#endif /* __RESOURCE_ENCODEREMULATOR_H */

/*----- END OF FILE ---------------------------------------------------------------------------------------*/
